SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ASSESSMENT_SELECTION_VELOCITY_RCPNT');

update sql_dtprovider set sqlQuery="SELECT
    T6.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.`loginId` AS LOGIN_ID,
    T15.`conditions` AS REJECTION_REMARK,
    CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,
    CONCAT(T9.addressText,
            ' ',
            T10.cityName,
            ', ',
            T11.countryName,
            ', ',
            T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    DATE_FORMAT(T14.admissionOfferStartDate, '%d-%m-%Y') AS OFFER_LETTER_START_DATE,
    DATE_FORMAT(T14.admissionOfferEndDate, '%d-%m-%Y') AS OFFER_LETTER_END_DATE,
    'APPLICANT' AS USER_TYPE_KEY,
    T18.programName AS PROGRAM,
    T17.batchName AS INTAKE,
    T19.itemValue AS INTAKE_YEAR,
    ml.code AS LANGUAGE_KEY,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
   T20.itemValue as CURRENT_ACTIVITY,
   T21.groupName AS PROGRAM_GROUP_NAME
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
         LEFT JOIN
     `current_activity` T20 ON T20.`id` = T2.`current_activity_id`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `external_user_association` T4 ON T4.`applicationId` = T1.`id`
        LEFT JOIN
    `external_users` T5 ON T5.`id` = T4.`externalUserId`
        LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
        LEFT JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
        LEFT JOIN
    application_condition T15 ON T15.applicationId = T1.id
        LEFT JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId
        && T9.addressTypeId = 10
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT JOIN
    program_selection_process T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
        LEFT JOIN
    prog_slctn_process_admisn_conf T14 ON T14.programSelectionProcessId = T13.id
        INNER JOIN
    prog_batch_seat_config T16 ON T16.id = T6.progBatchSeatConfigId
        INNER JOIN
    batches T17 ON T17.id = T16.programBatchId
        INNER JOIN
    programs T18 ON T18.id = T17.programId
   LEFT JOIN
       program_group T21 ON T21.id = T18.programGroupId
        INNER JOIN
    intake_year T19 ON T19.id = T17.intakeYearId
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
WHERE
   T6.id IN
   (
      namedParams
   )"
    ,
	jsonString=
    '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobile Code",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Login Id",
            "resultKey": "LOGIN_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Offer Letter Start Date",
            "resultKey": "OFFER_LETTER_START_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Offer Letter End Date",
            "resultKey": "OFFER_LETTER_END_DATE",
            "displayCode": "",
            "displayOrder": 12
        },      
        {
            "id": 14,
            "value": "Remarks",
            "resultKey": "REJECTION_REMARK",
            "displayCode": "",
            "displayOrder": 13
        },
		 {
			"id": 15,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 14
		},
          {
			"id": 16,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 15
		  },
           {
			"id": 17,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 16
		  },
		  {
              "id": 18,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 17
          },
		  {
               "id": 19,
               "value": "itemValue",
               "resultKey": "CURRENT_ACTIVITY",
               "displayCode": "",
               "displayOrder": 18
           },
           
            {
               "id": 20,
               "value": "groupName",
               "resultKey": "PROGRAM_GROUP_NAME",
               "displayCode": "",
               "displayOrder": 19
           }
    ]
}' where dataProviderId=@dataProviderId;